/*
 * mem_man.c
 *
 *  Created on: Nov 2, 2016
 *      Author: B52932
 */



#include "mem_man.h"

uint8_t is_mem_init = 0;						/* Variable used to flag is the memory has been initialized */
uint32_t flash_last_erased_sec = 0;				/* Last erased flash sector count */

void mem_man_write(BootPhraseStruct *BP){
	uint16_t data_size;
	uint32_t flash_prog_address;

	/* Check if memory is initialized */
	if(is_mem_init == 0){					/* Initialize memory */
		FLASH_Init((DEFAULT_SYSTEM_CLOCK / 2));
		is_mem_init = 1;
	}

	/* Get size and address */
	if(BP->F.PhraseType == '3'){
		uint32_t *tmp;

		/* Data size minus address (4) and CRC (1)*/
		data_size = BP->F.PhraseSize - 5;

		/* Get 32-bit address out of array */
		tmp = (uint32_t *) BP->F.PhraseAddress;
		flash_prog_address = LE2BE_32(*tmp) & 0xFFFFFFFF;
	} else if(BP->F.PhraseType == '2'){
		uint32_t *tmp;

		/* Data size minus address (3) and CRC (1)*/
		data_size = BP->F.PhraseSize - 4;

		/* Get 24-bit address out of array */
		tmp = (uint32_t *) BP->F.PhraseAddress;
		flash_prog_address = (LE2BE_32(*tmp) >> 8) & 0xFFFFFF;
	} else{
		uint32_t *tmp;

		/* Data size minus address (2) and CRC (1)*/
		data_size = BP->F.PhraseSize - 3;

		/* Get 16-bit address out of array */
		tmp = (uint32_t *) BP->F.PhraseAddress;
		flash_prog_address = (LE2BE_32(*tmp) >> 16) & 0xFFFF;
	}

	/* Check overlap with bootloader */
	if(flash_prog_address >= MEM_APP_START){

		/* Check if block has been erased aligned addresses (first address is assumed to be 0x2000) */
		if((flash_prog_address % FLASH_SECTOR_SIZE) == 0){

			/* Erase sector */
			FLASH_EraseSector(flash_prog_address);

			/* Store the address of the erased sector */
			flash_last_erased_sec = flash_prog_address;

		/* Check that the address from the SREC is within the previously erased sector (check misaligned addresses) */
		} else if((flash_last_erased_sec + FLASH_SECTOR_SIZE) < flash_prog_address){
			uint32_t tmp_add;
			/* Obtain address of sector to be erased */
			tmp_add = flash_prog_address % FLASH_SECTOR_SIZE;
			tmp_add = flash_prog_address - tmp_add;

			/* Erase sector */
			FLASH_EraseSector(tmp_add);

			/* Store the address of the erased sector */
			flash_last_erased_sec = tmp_add;
		}

		/* Program phrase */
		FLASH_Program(flash_prog_address, BP->F.PhraseData, data_size);
	}
}

/*
 * Checks if the memory was enabled and disables it
 **/
void mem_man_disable(void){

	if(is_mem_init){
		FLASH_reset();
	}
}
